/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.dialog.TrendPanelModel;
import java.util.Observable;

public abstract class AbstractTrendModel
extends Observable
implements TrendPanelModel.TrendModelChangedListener {
    public static String VISIBLITY_ATTR = "visibility";
    public static String EXTREMUM_ATTR = "extremum";
    protected double maxSampleValue = 0.0;
    protected double minSampleValue = 0.0;
    protected double maxTickValue;
    protected double minTickValue;
    protected double[] valueRangeTicks = null;
    protected TrendPanelModel globalModel;
    protected int localSampleFreq;
    protected boolean visible = true;

    AbstractTrendModel(TrendPanelModel panelModel) {
        panelModel.addTrendModelChangeListener(this);
        this.globalModel = panelModel;
        this.localSampleFreq = this.globalModel.getSampleProd();
        this.valueRangeTicks = new double[panelModel.getTrendRow() + 1];
        this.updateRangeValueOf(0.0);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public abstract void flushOneSample();

    public double[] getValueTickers() {
        return this.valueRangeTicks;
    }

    protected void updateRangeValue() {
        if (this.maxSampleValue != this.minSampleValue && this.maxSampleValue < this.maxTickValue && this.minSampleValue > this.minTickValue && this.maxSampleValue > this.minTickValue + (this.maxTickValue - this.minTickValue) * this.globalModel.trendRangeFactor && this.minSampleValue < this.minTickValue + (this.maxTickValue - this.minTickValue) * (1.0 - this.globalModel.trendRangeFactor)) {
            return;
        }
        if (this.maxSampleValue == this.minSampleValue) {
            this.updateRangeValueOf(this.maxSampleValue);
        } else {
            double fRange = (this.maxSampleValue - this.minSampleValue) / this.globalModel.trendRangeFactor / (double)this.globalModel.getTrendRow();
            int range = (int)Math.round(fRange);
            if ((double)range < fRange) {
                ++range;
            }
            if (range < 1) {
                range = 1;
            }
            this.minTickValue = Math.floor((this.maxSampleValue + this.minSampleValue) / 2.0 - (double)(range * this.globalModel.getTrendRow() / 2));
            this.maxTickValue = this.minTickValue + (double)(this.globalModel.getTrendRow() * range);
            this.calcValueTickers();
        }
    }

    protected void updateRangeValueOf(double value) {
        int iValue = (int)Math.floor(value);
        int row = this.globalModel.getTrendRow();
        if (row % 2 == 0 || Math.floor(value) != value) {
            this.maxTickValue = iValue + row / 2;
            this.minTickValue = iValue - row / 2;
        } else {
            this.maxTickValue = iValue + row;
            this.minTickValue = iValue - row;
        }
        this.calcValueTickers();
    }

    protected void calcValueTickers() {
        double stepValue = (this.maxTickValue - this.minTickValue) / (double)this.globalModel.getTrendRow();
        for (int loop = 0; loop <= this.globalModel.getTrendRow(); ++loop) {
            this.valueRangeTicks[loop] = this.minTickValue + (double)loop * stepValue;
        }
    }

    public void trendModelChanged(TrendPanelModel.TrendModelChangEvent evt) {
        if (evt.getPropertyName().equals(TrendPanelModel.TrendModelChangEvent.PROP_SAMPLE_FREQ)) {
            this.setSampleProd((Integer)evt.getNewValue());
        }
    }

    public abstract void setSampleProd(int var1);

    public abstract void clear();
}

